package com.getmati.mati_sdk.di

import com.getmati.mati_sdk.managers.request_manager.ApiRequestManager
import com.getmati.mati_sdk.ui.data_prefetch.DataPrefetchVm
import com.getmati.mati_sdk.ui.doc_hint.DocSkipVm
import com.getmati.mati_sdk.ui.document.DocUploadVm
import com.getmati.mati_sdk.ui.email.email_submission.EmailSubmissionVm
import com.getmati.mati_sdk.ui.email.email_validation.EmailVerificationVm
import com.getmati.mati_sdk.ui.esign.ESignVM
import com.getmati.mati_sdk.ui.iprestrictions.VpnDetectedVM
import com.getmati.mati_sdk.ui.liveness.VideoUploadVm
import com.getmati.mati_sdk.ui.verification.VerificationVm
import com.getmati.mati_sdk.ui.phonevalidation.vm.PhoneInputVM
import com.getmati.mati_sdk.ui.phonevalidation.vm.SmsCodeInputVM
import com.getmati.mati_sdk.ui.selfie.SelfieUploadVm
import com.getmati.mati_sdk.ui.web.WebVerificationVm
import org.koin.android.ext.koin.androidContext
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module

val viewModelModule = module {

    viewModel {
        DataPrefetchVm(get(), get(), get(), get(), get())
    }

    viewModel {
        VerificationVm(get(), get(), get(), get(), get())
    }

    viewModel {
        PhoneInputVM(get(), get(), get())
    }

    viewModel {
        SmsCodeInputVM(get())
    }

    viewModel {
        VpnDetectedVM(get(), get(), get())
    }

    viewModel {
        DocSkipVm(get())
    }

    viewModel {
        DocUploadVm(get())
    }

    viewModel {
        EmailSubmissionVm(get())
    }

    viewModel {
        EmailVerificationVm(get())
    }

    viewModel {
        ESignVM(get())
    }

    viewModel { parameters ->
        SelfieUploadVm(selfiePath = parameters.get(),get(), get())
    }

    viewModel {parameters ->
        WebVerificationVm(type = parameters.get(), get(), get<ApiRequestManager>().webVerificationBaseUrl)
    }

    viewModel { parameters ->
        VideoUploadVm(
            videoRepo = parameters.get(),
            path = parameters.get(),
            biometricRuntimeRepo = parameters.get()
        )
    }
}