package com.getmati.mati_sdk.events

internal class MixpanelEvents {

    companion object {
        const val MATI_VERIFICATION_START = "mati_verification_start"
        const val MATI_VERIFICATION_FINISHED = "mati_verification_finished"
        const val MATI_CANCEL_CONFIRM = "mati_cancel_confirm"

        const val SDK_INSTRUCTION_UPLOAD_SCREEN_DISPLAYED = "sdk_instructions_upload_screen_displayed"
        const val SDK_INSTRUCTION_DOCUMENT_READ = "sdk_instructions_document_read"
        const val SDK_DOCUMENT_START = "sdk_document_start"
        const val SDK_UPLOADING_START = "sdk_uploading_start"
        const val SDK_DOCUMENT_UPLOADED = "sdk_document_uploaded"

        const val SDK_LIVENESS_START = "sdk_liveness_start"
        const val SDK_LIVENESS_UPLOAD_START = "sdk_liveness_upload_start"
        const val SDK_LIVENESS_UPLOADED = "sdk_liveness_uploaded"

        const val SDK_SELFIE_INSTRUCTIONS_DISPLAYED = "sdk_selfie_instructions_displayed"
        const val SDK_SELFIE_UPLOADED = "sdk_selfie_uploaded"
        const val SDK_ERROR_SELFIE_TRY_AGAIN_CLICKED = "sdk_error_selfie_try_again_clicked"

        const val SDK_INPUT_UPLOAD_ERROR = "sdk_input_upload_error"

        const val SDK_CAMERA_DENIED = "sdk_camera_denied" // upload / error / camera permission

        //UPLOAD ERRORS
        const val SDK_ERROR_GRAYSCALE = "sdk_error_grayscale_document" // upload / error ...
        const val SDK_ERROR_NOT_PHYSICAL = "sdk_error_not_physical_document"
        const val SDK_ERROR_NO_DOCUMENT = "sdk_error_unable_to_recognize_document_type"
        const val SDK_ERROR_TWICE_UPLOAD_SAME = "sdk_error_trying_to_upload_same_photo_twice"
        const val SDK_ERROR_IMAGE_TOO_SMALL = "sdk_error_small_size_displayed"
        const val SDK_ERROR_SELFIE_DISPLAYED = "sdk_error_selfie_displayed"
        const val SDK_ERROR_DOC_NO_TEXT = "sdk_error_document_notext_displayed"
        const val SDK_ERROR_IMAGE_TOO_BIG = "sdk_error_largefile_displayed"

        // ACTIONS
        const val SDK_LIVENESS_RETAKE_CLICKED = "liveness_retake_clicked"
        const val SDK_LIVENESS_REPEAT_TEST_CLICKED = "liveness_repeat_test_clicked"
        const val SDK_SCREEN_START_BUTTON_CLICKED = "start_button_clicked"
        const val SDK_SCREEN_UPLOADING_BACK_CLICKED = "document_upload_back_clicked"
        const val SDK_SCREEN_EXIT_CONTINUE_CLICKED = "exit_screen_continue_clicked"
        const val SDK_ERROR_IMAGE_TOO_SMALL_TRYAGAIN_CLICKED = "sdk_error_small_size_tryagain_clicked"
        const val SDK_ERROR_DOC_NO_TEXT_TRYAGAIN_CLICKED = "sdk_error_document_notext_tryagain_clicked"
        const val SDK_ERROR_IMAGE_TOO_BIG_TRYAGAIN_CLICKED = "sdk_error_largefile_tryagain_clicked"
        const val SDK_ERROR_SMTH_WENT_WRONG_TRYAGAIN_CLICKED = "sdk_error_common_tryagain_clicked"
        const val SDK_SELFIE_TAKE_CLICKED = "sdk_selfie_take_clicked"
        const val SDK_SELFIE_UPLOAD_CLICKED = "sdk_selfie_upload_clicked"
        const val SDK_SELFIE_RETAKE_CLICKED = "sdk_selfie_retake_clicked"
        const val SDK_SCREEN_VERIFIED_DISPLAYED = "mati_verification_finished_clicked"

        // SCREENS
        const val SDK_LOADING_SPINNER_SCREEN = "sdk_loading_displayed" // screen
        const val SDK_SCREEN_START_DISPLAYED = "sdk_start_screen_displayed"
        const val SDK_SCREEN_DOC_COUNTRY_DISPLAYED = "sdk_select_doc_country_displayed"
        const val SDK_ERROR_LIVENESS_DISPLAYED = "sdk_error_liveness_displayed"
        const val SDK_CANCEL_SCREEN_DISPLAYED = "sdk_cancel_screen_displayed"
        const val SDK_SCREEN_DOC_TYPE_COMPLETED = "select_document_country"
        const val SDK_UPLOADING_SCREEN = "upload_document"
        const val SDK_SCREEN_TAKE_SELFIE_DISPLAYED = "take_selfie"
        const val SDK_ERROR_SCREEN_DISPLAYED = "error"

    }

}