package com.getmati.mati_sdk.logger

import android.util.Log
import com.getmati.mati_sdk.BuildConfig

class DefaultLogger : Logger {
    override fun logError(error: String) {
        if(BuildConfig.DEBUG) {
            Log.e(TAG, error)
        }
    }

    override fun logInfo(info: String) {
        if(BuildConfig.DEBUG) {
            Log.i(TAG, info)
        }
    }

    companion object {
        const val TAG = "DefaultLogger"
    }
}