package com.getmati.mati_sdk.managers

import android.content.Context
import com.getmati.mati_sdk.di.apiModule
import com.getmati.mati_sdk.di.applicationModule
import com.getmati.mati_sdk.di.repoModule
import com.getmati.mati_sdk.di.viewModelModule
import io.ktor.client.*
import org.koin.android.ext.koin.androidContext
import org.koin.android.ext.koin.androidLogger
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject
import org.koin.core.context.GlobalContext
import org.koin.core.context.unloadKoinModules
import org.koin.core.logger.Level

class AppComponentRegistry : KoinComponent {

    private val client by inject<HttpClient>()
    private val modules = applicationModule + repoModule + viewModelModule + apiModule

    fun registerComponents(applicationContext: Context) {
        GlobalContext.startKoin {
            androidLogger(Level.INFO)
            androidContext(applicationContext)
            modules(modules)
        }
    }

    fun unRegisterComponents() {
        client.close()

        unloadKoinModules(modules)
        GlobalContext.stopKoin()
    }
}