package com.getmati.mati_sdk.managers.prefetch

import android.util.Log
import com.getmati.mati_sdk.models.clean.input.Input
import com.getmati.mati_sdk.models.clean.verification.VerificationFlow
import com.getmati.mati_sdk.models.clean.web_config.WebContainerConfig
import com.getmati.mati_sdk.ui.data_prefetch.model.Config
import com.getmati.mati_sdk.ui.data_prefetch.model.PrefetchedData

internal class PrefetchDataHolder {

    private var _verificationFlow: VerificationFlow? = null
    private var _initialInputs: List<Input> = emptyList()
    private var _prefetchedData: PrefetchedData? = null
    private var _webContainerConfig: List<WebContainerConfig>? = null
    private var _config: Config? = null

    val config: Config?
        get() = _prefetchedData?.config ?: _config

    val prefetchedData: PrefetchedData
        get() = _prefetchedData!!

    val verificationFlow: VerificationFlow
        get() = _verificationFlow!!

    val initialInputs: List<Input>
        get() = _initialInputs

    val webContainerConfig: List<WebContainerConfig>
        get() = _webContainerConfig!!

    val hasPrefetchedData
        get() = _prefetchedData != null

    fun holdPrefetchData(data: PrefetchedData) {
        _prefetchedData = data
    }

    fun holdConfig(config: Config?) {
        _config = config
    }

    fun holdInitialInputs(initialInputs: List<Input>) {
        _initialInputs = initialInputs
    }

    fun holdVerificationFlow(verificationFlow: VerificationFlow) {
        _verificationFlow = verificationFlow
    }

    fun holdWebContainerConfigs(webContainerConfig: List<WebContainerConfig>) {
        _webContainerConfig = webContainerConfig
    }

    fun clearPrefetchData() {
        _initialInputs = emptyList()
        _verificationFlow = null
        _prefetchedData = null
        _config = null
    }


}