package com.getmati.mati_sdk.managers.prefetch

import androidx.lifecycle.SavedStateHandle
import com.getmati.mati_sdk.models.clean.input.Input
import com.getmati.mati_sdk.models.clean.verification.VerificationFlow
import com.getmati.mati_sdk.ui.data_prefetch.model.PrefetchedData

internal const val ARG_VERIFICATION_FLOW = "ARG_VERIFICATION_FLOW"
internal const val ARG_DATA_PREFETCH = "ARG_DATA_PREFETCH"
internal const val ARG_INPUTS = "ARG_INPUTS"

internal class PrefetchDataSaveStateHandler {

    fun handle(prefetchDataHolder: PrefetchDataHolder, savedStateHandle: SavedStateHandle) {
        if (!savedStateHandle.contains(ARG_DATA_PREFETCH)) {
            savedStateHandle.set(ARG_DATA_PREFETCH, prefetchDataHolder.prefetchedData)
        } else {
            val data = savedStateHandle.get<PrefetchedData>(ARG_DATA_PREFETCH)
            data?.let {
                prefetchDataHolder.holdPrefetchData(it)
            }
        }
        if (!savedStateHandle.contains(ARG_VERIFICATION_FLOW)) {
            savedStateHandle.set(ARG_VERIFICATION_FLOW, prefetchDataHolder.verificationFlow)
        } else {
            val data = savedStateHandle.get<VerificationFlow>(ARG_VERIFICATION_FLOW)
            data?.let {
                prefetchDataHolder.holdVerificationFlow(it)
            }
        }
        if (!savedStateHandle.contains(ARG_INPUTS)) {
            savedStateHandle.set(ARG_INPUTS, prefetchDataHolder.initialInputs)
        } else {
            val data = savedStateHandle.get<List<Input>>(ARG_INPUTS)
            data?.let {
                prefetchDataHolder.holdInitialInputs(it)
            }
        }
    }

    fun putAllData(prefetchDataHolder: PrefetchDataHolder, savedStateHandle: SavedStateHandle) {
        savedStateHandle.set(ARG_DATA_PREFETCH, prefetchDataHolder.prefetchedData)
        savedStateHandle.set(ARG_VERIFICATION_FLOW, prefetchDataHolder.verificationFlow)
        savedStateHandle.set(ARG_INPUTS, prefetchDataHolder.initialInputs)
    }

    fun putPrefetchData(prefetchDataHolder: PrefetchDataHolder, savedStateHandle: SavedStateHandle) {
        savedStateHandle.set(ARG_DATA_PREFETCH, prefetchDataHolder.prefetchedData)
    }
}