package com.getmati.mati_sdk.managers.reporter

import com.getmati.mati_sdk.logger.LoggerFactory
import kotlin.system.exitProcess


abstract class CrashReporter {

    private val oldHandler = Thread.getDefaultUncaughtExceptionHandler()
    private val newHandler = Thread.UncaughtExceptionHandler { thread, throwable ->
        try {
            LoggerFactory.logError(throwable.localizedMessage?: throwable.toString())
            report(thread, throwable)
            Thread.sleep(1000L)
        } catch (_: Exception) {
        }
        oldHandler?.uncaughtException(thread, throwable) ?: exitProcess(2)
    }

    abstract fun report(thread: Thread, throwable: Throwable)

    fun registerUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(newHandler)
    }

    fun unregisterUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(oldHandler)
    }
}