package com.getmati.mati_sdk.managers.reporter

import android.app.Application
import com.getmati.mati_sdk.BuildConfig
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.sentry.io.sentry.Hub
import com.getmati.mati_sdk.sentry.io.sentry.SentryEvent
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel
import com.getmati.mati_sdk.sentry.io.sentry.android.core.AndroidOptionsInitializer
import com.getmati.mati_sdk.sentry.io.sentry.android.core.SentryAndroidOptions
import com.getmati.mati_sdk.sentry.io.sentry.exception.ExceptionMechanismException
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Mechanism

internal class SentryCrashReporter(application: Application,
                                   prefetchDataHolder: PrefetchDataHolder) : CrashReporter() {

    private val hub: Hub

    init {
        val sdkType = prefetchDataHolder.config?.sdkType
        val options = SentryAndroidOptions()
        AndroidOptionsInitializer.init(options, application)
        hub = Hub(options)
        hub.setTag("MatiSdkVersion", BuildConfig.VERSION_NAME)
        hub.setTag("MatiSdkType", "android${sdkType?.let{ "_$it" } ?: ""}")
        hub.setTag("Merchant", prefetchDataHolder.prefetchedData.merchantId)
        for (integration in options.integrations) {
            integration.register(hub, options)
        }
    }

    override fun report(thread: Thread, thrown: Throwable) {
        val mechanism = Mechanism().apply {
            isHandled = false
            type = "UncaughtExceptionHandler"
        }

        val event = SentryEvent(ExceptionMechanismException(mechanism, thrown, thread)).apply {
            level = SentryLevel.FATAL
        }

        hub.captureEvent(event)
    }
}