package com.getmati.mati_sdk.managers.shared_pref

import android.app.Application
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.edit
import com.getmati.mati_sdk.Constants
import com.getmati.mati_sdk.models.clean.Language
import java.util.*

class SharedPreferenceManager(application: Application) {

    private val preferences =
        application.getSharedPreferences(Constants.MATI_PREFS_NAME, AppCompatActivity.MODE_PRIVATE)

    var shouldShowAnalyticsDialogs: Boolean
        get() = preferences.getBoolean(Constants.ANALYTICS_DIALOG_KEY, false)
        set(value) {
            preferences.edit {
                putBoolean(Constants.ANALYTICS_DIALOG_KEY, value)
            }
        }

    var language: String
        get() = preferences.getString(Constants.PREFS_LANGUAGE, defaultLanguage())
            ?: defaultLanguage()
        set(value) {
            preferences.edit {
                putString(Constants.PREFS_LANGUAGE, value)
            }
        }

    fun deviceUUID() =
        preferences.let {
            if (it.contains(Constants.DEVICE_UUID_KEY)) {
                it.getString(Constants.DEVICE_UUID_KEY, "UNINITIALIZED") ?: "UNINITIALIZED"
            } else {
                val uuid = UUID.randomUUID().toString()
                it.edit().putString(Constants.DEVICE_UUID_KEY, uuid).apply()
                uuid
            }
        }

    private fun defaultLanguage(): String {
        val default = Locale.getDefault().language
        return if (Language.values().map { it.id }.contains(default)) {
            default
        } else {
            Language.ENGLISH.id
        }
    }
}