package com.getmati.mati_sdk.mappers

import com.getmati.mati_sdk.models.clean.*
import com.getmati.mati_sdk.models.socket.response.join_room.CustomDocumentResponse
import com.getmati.mati_sdk.models.socket.response.join_room.VerificationFlowResponse
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.decodeFromJsonElement
import org.koin.core.context.GlobalContext

internal fun VerificationFlowResponse.toDocuments(): List<List<Document>> {

    val json = GlobalContext.get().get<Json>()
    val result = mutableListOf<List<Document>>()
    verificationSteps?.forEachIndexed { index, steps ->
        val docs = mutableListOf<Document>()
        steps.forEach { name ->
            val doc = when (name) {
                Passport.DOC_ID_PASSPORT -> Passport()
                DrivingLicense.DOC_ID_DRIVING_LICENSE -> DrivingLicense()
                NationalId.DOC_ID_NATIONAL_ID -> NationalId()
                ProofOfResidency.DOC_ID_PROOF_OF_RESIDENCY -> ProofOfResidency()
                else -> if (name.startsWith(CustomDoc.PREFIX_CUSTOM_DOCUMENT) && customDocumentConfig != null) {
                    val customDocJsonString = customDocumentConfig[name].toString()
                    val customDocJson = json.parseToJsonElement(customDocJsonString)
                    json.decodeFromJsonElement<CustomDocumentResponse>(customDocJson)
                        .toCustomDoc()
                } else throw IllegalArgumentException("Unhandled document id")
            }
            docs.add(doc)
        }
        result.add(index, docs)
    }
    return result.toList()
}

internal fun CustomDocumentResponse.toCustomDoc(): CustomDoc {
    return CustomDoc(
        skippable = skippable,
        hintImageUrls = hintImages.let {
            val images = mutableListOf(it.front.publicUrl)
            it.back?.let { back -> images.add(back.publicUrl) }
            images
        },
        pages = pages,
        singleFile = singleFile,
        name = name,
        description = description,
        id = id
    )
}