package com.getmati.mati_sdk.mappers

import com.getmati.mati_sdk.models.socket.response.join_room.ElectronicSignatureResponse
import com.getmati.mati_sdk.ui.ESignVerificationStep
import com.getmati.mati_sdk.ui.esign.model.DocToSign

internal fun ElectronicSignatureResponse.toESignVerificationStep(): ESignVerificationStep? {

    val templatesResponse = this.electronicSignatureTemplatesResponse
    templatesResponse?.let { templates ->
        val orders = templates.order
        val documents = templates.documents
        val idToUrl = orders
            .mapIndexed { index, id -> id to documents[index].originalDocument }
            .toMap()

        if (idToUrl.isNotEmpty()) {
            val docsToSign = orders.map { id ->
                DocToSign(id, idToUrl[id]?.publicUrl ?: "")
            }
            return ESignVerificationStep(docsToSign)
        }
    }
    return null
}