package com.getmati.mati_sdk.mappers

import com.getmati.mati_sdk.models.clean.input.InputError
import com.getmati.mati_sdk.models.clean.input.InputErrorDetail
import com.getmati.mati_sdk.models.clean.verification.VerificationErrorDetail
import com.getmati.mati_sdk.models.clean.verification.VerificationResultError
import com.getmati.mati_sdk.models.socket.response.join_room.ErrorDetailsResponse
import com.getmati.mati_sdk.models.socket.response.join_room.ErrorResponse
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.decodeFromJsonElement
import org.koin.core.context.GlobalContext

internal fun ErrorResponse.toInputError(): InputError {

    val error = this
    val errorDetailsResponse = error.toErrorDetailResponse()
    val errorDetail = if (errorDetailsResponse != null) {
        InputErrorDetail(
            text = errorDetailsResponse.text,
            attemptsLeft = errorDetailsResponse.attemptsLeft
        )
    } else {
        null
    }
    return when (val code = error.code) {
        "connectionData.restricted" -> InputError(code, error.severity != "critical", errorDetail)
        "connectionData.vpnDetected" -> InputError(code, error.optional ?: false, errorDetail)
        else -> InputError(code ?: "", true, errorDetail)
    }
}

internal fun ErrorResponse.toVerificationResultError(): VerificationResultError {

    val error = this
    val errorDetailsResponse = error.toErrorDetailResponse()
    val errorDetail = if (errorDetailsResponse != null) {
        VerificationErrorDetail(text = errorDetailsResponse.text)
    } else {
        null
    }
    return VerificationResultError(error.code ?: "", error.optional ?: false, errorDetail)
}

internal fun ErrorResponse.toErrorDetailResponse(): ErrorDetailsResponse? {
    val errorDetailsResponse = (detail as? JsonObject) ?: return null
    val jsonBuilder = GlobalContext.get().get<Json>()
    val json = jsonBuilder.parseToJsonElement(errorDetailsResponse.toString())
    return jsonBuilder.decodeFromJsonElement<ErrorDetailsResponse>(json)
}