package com.getmati.mati_sdk.mappers

import android.util.Base64
import com.getmati.mati_sdk.models.api.response.IdTokenResponse
import com.getmati.mati_sdk.models.api.response.NewAuthorizationTokenResponse
import kotlinx.serialization.json.Json
import org.koin.core.context.GlobalContext
import kotlinx.serialization.json.decodeFromJsonElement

internal fun NewAuthorizationTokenResponse.toIdToken(): IdTokenResponse {

    val json = GlobalContext.get().get<Json>()
    val payload = idToken.split("\\.".toRegex())[1]
    val byteArray = Base64.decode(payload, Base64.URL_SAFE)
    val jsonString = String(byteArray)
    val idTokenJson = json.parseToJsonElement(jsonString)
    return json.decodeFromJsonElement(idTokenJson)
}