package com.getmati.mati_sdk.mappers

import com.getmati.mati_sdk.models.clean.input.Input
import com.getmati.mati_sdk.models.clean.input.InputData
import com.getmati.mati_sdk.models.clean.input.InputDataPages
import com.getmati.mati_sdk.models.clean.input.InputStatus
import com.getmati.mati_sdk.models.socket.response.join_room.InputDataResponse
import com.getmati.mati_sdk.models.socket.response.join_room.InputResponse

internal fun InputResponse.toInput(): Input {

    val response = this
    val errorResponse = response.errorResponse
    val inputDataResponse: InputDataResponse? = response.inputData
    val inputData = inputDataResponse?.let {
        val inputDataPages = InputDataPages(it.inputDataPages?.front ?: false)
        InputData(inputDataPages, it.countryCode)
    }
    return Input(
        id = response.id,
        status = response.status.let { status ->
            when (status) {
                200 -> InputStatus.SUCCESS
                100 -> InputStatus.IN_PROGRESS
                else -> InputStatus.ERROR
            }
        },
        group = response.group,
        inputData = inputData,
        error = errorResponse?.toInputError()
    )
}

internal fun List<InputResponse>.toInputList(): List<Input> {
    return map { it.toInput() }
}