package com.getmati.mati_sdk.mappers

import com.getmati.mati_sdk.models.clean.verification.VerificationDataResult
import com.getmati.mati_sdk.models.clean.verification.VerificationResult
import com.getmati.mati_sdk.models.socket.response.join_room.VerificationResultResponse

internal fun VerificationResultResponse.toVerificationResult(): VerificationResult {

    val verificationResultResponse = verificationData?.let { VerificationDataResult(verificationData.inputId) }

    return VerificationResult(
        id = id,
        groupIdx = this.group ?: 0,
        verificationResultError = errorResponse?.toVerificationResultError(),
        text = errorResponse?.toErrorDetailResponse()?.text,
        verificationDataResult = verificationResultResponse,
        optional = optional
    )
}