package com.getmati.mati_sdk.models.api.response

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class CreateVerificationResponse(
    @SerialName("id")
    val id: String? = null,
    @SerialName("identity")
    val identityId: String? = null,
    @SerialName("inputs")
    val inputs: List<CreateVerificationInputResponse>? = null,
    @SerialName("error")
    val errorMessage: String? = null
) {

    val voiceDataText: String?
        get() {
            return inputs?.find { it.id == "voice-video" }?.createVerificationInputDataResponse?.text
        }
}

@Serializable
internal data class CreateVerificationInputResponse(
    @SerialName("id")
    val id: String? = null,
    @SerialName("data")
    val createVerificationInputDataResponse: CreateVerificationInputDataResponse? = null,
)

@Serializable
internal data class CreateVerificationInputDataResponse(
    @SerialName("text")
    val text: String? = null,
)