package com.getmati.mati_sdk.models.clean

internal enum class Countries(
    enName: String,
    esName: String,
    frName: String,
    ptName: String,
    ruName: String
) {
    AD("Andorra", "Andorra", "Andorre", "Andorra", "Андорра"), AE(
        "United Arab Emirates",
        "Emiratos Árabes Unidos",
        "Emirats Arabes Unis",
        "Emirados Árabes Unidos",
        "ОАЭ"
    ),
    AF(
        "Afghanistan",
        "Afganistán",
        "Afghanistan",
        "Afeganistão",
        "Афганистан"
    ),
    AG(
        "Antigua & Barbuda",
        "Antigua y Barbuda",
        "Antigua et Barbuda",
        "Antígua e Barbuda",
        "Антигуа и Барбуда"
    ),
    AI("Anguilla", "Anguila", "Anguilla", "Anguila", "Ангилья"), AL(
        "Albania",
        "Albania",
        "Albanie",
        "Albânia",
        "Албания"
    ),
    AM("Armenia", "Armenia", "Arménie", "Armênia", "Армения"), AO(
        "Angola",
        "Angola",
        "Angola",
        "Angola",
        "Ангола"
    ),
    AQ("Antarctica", "Antártida", "Antarctique", "Antártica", "Антарктида"), AR(
        "Argentina",
        "Argentina",
        "Argentine",
        "Argentina",
        "Аргентина"
    ),
    AT("Austria", "Austria", "L'Autriche", "Áustria", "Австрия"), AU(
        "Australia",
        "Australia",
        "Australie",
        "Austrália",
        "Австралия"
    ),
    AW("Aruba", "Aruba", "Aruba", "Aruba", "Аруба"), AZ(
        "Azerbaijan",
        "Azerbaiyán",
        "Azerbaïdjan",
        "Azerbaijão",
        "Азербайджан"
    ),
    BA(
        "Bosnia & Herzegovina",
        "Bosnia y Herzegovina",
        "Bosnie et Herzégovine",
        "Bósnia e Herzegovina",
        "Босния и Герцеговина"
    ),
    BB("Barbados", "Barbados", "Barbade", "Barbados", "Барбадос"), BD(
        "Bangladesh",
        "Bangladesh",
        "Bangladesh",
        "Bangladesh",
        "Бангладеш"
    ),
    BE("Belgium", "Bélgica", "Belgique", "Bélgica", "Бельгия"), BF(
        "Burkina Faso",
        "Burkina Faso",
        "Burkina Faso",
        "Burkina Faso",
        "Буркина-Фасо"
    ),
    BG("Bulgaria", "Bulgaria", "Bulgarie", "Bulgária", "Болгария"), BH(
        "Bahrain",
        "Bahrein",
        "Bahrein",
        "Barém",
        "Бахрейн"
    ),
    BI("Burundi", "Burundi", "Burundi", "Burundi", "Бурунди"), BJ(
        "Benin",
        "Benin",
        "Bénin",
        "Benin",
        "Бенин"
    ),
    BM("Bermuda", "Islas Bermudas", "Bermudes", "Bermudas", "Бермудские о-ва"), BN(
        "Brunei",
        "Brunei",
        "Brunei",
        "Brunei",
        "Бруней-Даруссалам"
    ),
    BO("Bolivia", "Bolivia", "Bolivie", "Bolívia", "Боливия"), BR(
        "Brazil",
        "Brasil",
        "Brésil",
        "Brasil",
        "Бразилия"
    ),
    BS("Bahamas", "Bahamas", "Bahamas", "Bahamas", "Багамы"), BT(
        "Bhutan",
        "Bután",
        "Bhoutan",
        "Butão",
        "Бутан"
    ),
    BW("Botswana", "Botsuana", "Botswana", "Botsuana", "Ботсвана"), BY(
        "Belarus",
        "Bielorrusia",
        "Biélorussie",
        "Belarus",
        "Беларусь"
    ),
    BZ("Belize", "Belice", "Belize", "Belize", "Белиз"), CA(
        "Canada",
        "Canadá",
        "Canada",
        "Canadá",
        "Канада"
    ),
    CD(
        "Congo - Kinshasa",
        "Congo - Kinshasa",
        "Congo - Kinshasa",
        "Congo - Kinshasa",
        "Конго - Киншаса"
    ),
    CF(
        "Central African Republic",
        "República Centroafricana",
        "République centrafricaine",
        "República Centro-Africana",
        "Центрально-Африканская Республика"
    ),
    CG(
        "Congo - Brazzaville",
        "Congo - Brazzaville",
        "Congo - Brazzaville",
        "Congo - Brazzaville",
        "Конго - Браззавиль"
    ),
    CH("Switzerland", "Suiza", "Suisse", "Suíça", "Швейцария"), CI(
        "Côte d’Ivoire",
        "Costa de Marfil",
        "Côte d’Ivoire",
        "Costa do Marfim",
        "Кот-д'Ивуар"
    ),
    CL("Chile", "Chile", "Chili", "Chile", "Чили"), CM(
        "Cameroon",
        "Camerún",
        "Cameroun",
        "Camarões",
        "Камерун"
    ),
    CN("China", "China", "Chine", "China", "Китай"), CO(
        "Colombia",
        "Colombia",
        "Colombie",
        "Colômbia",
        "Колумбия"
    ),
    CR("Costa Rica", "Costa Rica", "Costa Rica", "Costa Rica", "Коста-Рика"), CU(
        "Cuba",
        "Cuba",
        "Cuba",
        "Cuba",
        "Куба"
    ),
    CW("Curaçao", "Curazao", "Curacao", "Curaçao", "Кюрасао"), CY(
        "Cyprus",
        "Chipre",
        "Chypre",
        "Chipre",
        "Кипр"
    ),
    CZ(
        "Czech Republic",
        "Republica checa",
        "République Tchèque",
        "República Checa",
        "Чехия"
    ),
    DE("Germany", "Alemania", "Allemagne", "Alemanha", "Германия"), DJ(
        "Djibouti",
        "Djibouti",
        "Djibouti",
        "Djibuti",
        "Джибути"
    ),
    DK("Denmark", "Dinamarca", "Danemark", "Dinamarca", "Дания"), DM(
        "Dominica",
        "Dominica",
        "La Dominique",
        "Dominica",
        "Доминика"
    ),
    DO(
        "Dominican Republic",
        "República Dominicana",
        "République Dominicaine",
        "República Dominicana",
        "Доминиканская Республика"
    ),
    DZ("Algeria", "Argelia", "Algérie", "Argélia", "Алжир"), EC(
        "Ecuador",
        "Ecuador",
        "Équateur",
        "Equador",
        "Эквадор"
    ),
    EE("Estonia", "Estonia", "Estonie", "Estônia", "Эстония"), EG(
        "Egypt",
        "Egipto",
        "Egypte",
        "Egito",
        "Египет"
    ),
    EH(
        "Western Sahara",
        "Sahara Occidental",
        "Sahara occidental",
        "Saara Ocidental",
        "Западная Сахара"
    ),
    ER("Eritrea", "Eritrea", "Erythrée", "Eritréia", "Эритрея"), ES(
        "Spain",
        "España",
        "Espagne",
        "Espanha",
        "Испания"
    ),
    ET("Ethiopia", "Etiopía", "Ethiopie", "Etiópia", "Эфиопия"), FI(
        "Finland",
        "Finlandia",
        "Finlande",
        "Finlândia",
        "Финляндия"
    ),
    FJ("Fiji", "Fiyi", "Fidji", "Fiji", "Фиджи"), FM(
        "Micronesia",
        "Micronesia",
        "Micronésie",
        "Micronésia",
        "Федеративные Штаты Микронезии"
    ),
    FR("France", "Francia", "France", "França", "Франция"), GA(
        "Gabon",
        "Gabón",
        "Gabon",
        "Gabão",
        "Габон"
    ),
    GB(
        "United Kingdom",
        "Reino Unido",
        "Royaume-Uni",
        "Reino Unido",
        "Великобритания"
    ),
    GD("Grenada", "Granada", "Grenade", "Granada", "Гренада"), GE(
        "Georgia",
        "Georgia",
        "Géorgie",
        "Georgia",
        "Грузия"
    ),
    GF(
        "French Guiana",
        "Guayana Francesa",
        "Guinée Française",
        "Guiana Francesa",
        "Французская Гвиана"
    ),
    GG("Guernsey", "Guernsey", "Guernesey", "Guernsey", "Гернси"), GH(
        "Ghana",
        "Ghana",
        "Ghana",
        "Gana",
        "Гана"
    ),
    GI("Gibraltar", "Gibraltar", "Gibraltar", "Gibraltar", "Гибралтар"), GL(
        "Greenland",
        "Groenlandia",
        "Groenland",
        "Gronelândia",
        "Гренландия"
    ),
    GM("Gambia", "Gambia", "Gambie", "Gâmbia", "Гамбия"), GN(
        "Guinea",
        "Guinea",
        "Guinée",
        "Guiné",
        "Гвинея"
    ),
    GP("Guadeloupe", "Guadalupe", "Guadeloupe", "Guadalupe", "Гваделупа"), GQ(
        "Equatorial Guinea",
        "Guinea Ecuatorial",
        "Guinée Équatoriale",
        "Guiné Equatorial",
        "Экваториальная Гвинея"
    ),
    GR("Greece", "Grecia", "Grèce", "Grécia", "Греция"), GT(
        "Guatemala",
        "Guatemala",
        "Guatemala",
        "Guatemala",
        "Гватемала"
    ),
    GU("Guam", "Guam", "Guam", "Guam", "Гуам"), GW(
        "Guinea-Bissau",
        "Guinea-Bissau",
        "Guinée Bissau",
        "Guiné-Bissau",
        "Гвинея-Бисау"
    ),
    GY("Guyana", "Guayana", "Guyane", "Guiana", "Гайана"), HK(
        "Hong Kong SAR China",
        "Hong Kong SAR China",
        "RAS chinoise de Hong Kong",
        "Hong Kong, SAR, China",
        "Гонконг (САР)"
    ),
    HN("Honduras", "Honduras", "Honduras", "Honduras", "Гондурас"), HR(
        "Croatia",
        "Croacia",
        "Croatie",
        "Croácia",
        "Хорватия"
    ),
    HT("Haiti", "Haití", "Haïti", "Haiti", "Гаити"), HU(
        "Hungary",
        "Hungría",
        "Hongrie",
        "Hungria",
        "Венгрия"
    ),
    ID("Indonesia", "Indonesia", "Indonésie", "Indonésia", "Индонезия"), IE(
        "Ireland",
        "Irlanda",
        "Irlande",
        "Irlanda",
        "Ирландия"
    ),
    IL("Israel", "Israel", "Israël", "Israel", "Израиль"), IM(
        "Isle of Man",
        "Isla del hombre",
        "Île de man",
        "Ilha de Man",
        "о-в Мэн"
    ),
    IN("India", "India", "Inde", "Índia", "Индия"), IQ(
        "Iraq",
        "Irak",
        "Irak",
        "Iraque",
        "Ирак"
    ),
    IR("Iran", "Irán", "Iran", "Irã", "Иран"), IS(
        "Iceland",
        "Islandia",
        "Islande",
        "Islândia",
        "Исландия"
    ),
    IT("Italy", "Italia", "Italie", "Itália", "Италия"), JM(
        "Jamaica",
        "Jamaica",
        "Jamaïque",
        "Jamaica",
        "Ямайка"
    ),
    JO("Jordan", "Jordán", "Jordan", "Jordânia", "Иордания"), JP(
        "Japan",
        "Japón",
        "Japon",
        "Japão",
        "Япония"
    ),
    KE("Kenya", "Kenia", "Kenya", "Quênia", "Кения"), KG(
        "Kyrgyzstan",
        "Kirguizstán",
        "Kirghizistan",
        "Quirguistão",
        "Киргизия"
    ),
    KH("Cambodia", "Camboya", "Cambodge", "Camboja", "Камбоджа"), KI(
        "Kiribati",
        "Kiribati",
        "Kiribati",
        "Kiribati",
        "Кирибати"
    ),
    KM("Comoros", "Comoras", "Les Comores", "Comores", "Коморы"), KN(
        "St. Kitts & Nevis",
        "San Cristóbal y Nieves",
        "Saint-Kitts-et-Nevis",
        "São Cristóvão e Nevis",
        "Сент-Китс и Невис"
    ),
    KR(
        "South Korea",
        "Corea del Sur",
        "Corée du Sud",
        "Coreia do Sul",
        "Республика Корея"
    ),
    KW("Kuwait", "Kuwait", "Koweit", "Kuwait", "Кувейт"), KY(
        "Cayman Islands",
        "Islas Caimán",
        "Îles Caïmans",
        "Ilhas Cayman",
        "Острова Кайман"
    ),
    KZ("Kazakhstan", "Kazajstán", "Kazakhstan", "Cazaquistão", "Казахстан"), LA(
        "Laos",
        "Laos",
        "Laos",
        "Laos",
        "Лаос"
    ),
    LB("Lebanon", "Líbano", "Liban", "Líbano", "Ливан"), LC(
        "St. Lucia",
        "Santa Lucía",
        "Sainte Lucie",
        "Santa Lúcia",
        "Сент-Люсия"
    ),
    LI(
        "Liechtenstein",
        "Liechtenstein",
        "Liechtenstein",
        "Liechtenstein",
        "Лихтенштейн"
    ),
    LK("Sri Lanka", "Sri Lanka", "Sri Lanka", "Sri Lanka", "Шри-Ланка"), LR(
        "Liberia",
        "Liberia",
        "Libéria",
        "Libéria",
        "Либерия"
    ),
    LS("Lesotho", "Lesoto", "Lesotho", "Lesoto", "Лесото"), LT(
        "Lithuania",
        "Lituania",
        "Lituanie",
        "Lituânia",
        "Литва"
    ),
    LU("Luxembourg", "Luxemburgo", "Luxembourg", "Luxemburgo", "Люксембург"), LV(
        "Latvia",
        "Letonia",
        "Lettonie",
        "Letônia",
        "Латвия"
    ),
    LY("Libya", "Libia", "Libye", "Líbia", "Ливия"), MA(
        "Morocco",
        "Marruecos",
        "Maroc",
        "Marrocos",
        "Марокко"
    ),
    MC("Monaco", "Mónaco", "Monaco", "Mônaco", "Монако"), MD(
        "Moldova",
        "Moldavia",
        "La Moldavie",
        "Moldávia",
        "Молдова"
    ),
    ME("Montenegro", "Montenegro", "Monténégro", "Montenegro", "Черногория"), MG(
        "Madagascar",
        "Madagascar",
        "Madagascar",
        "Madagáscar",
        "Мадагаскар"
    ),
    MH(
        "Marshall Islands",
        "Islas Marshall",
        "Iles Marshall",
        "Ilhas Marshall",
        "Маршалловы Острова"
    ),
    MK("Macedonia", "Macedonia", "Macédoine", "Macedônia", "Северная Македония"), ML(
        "Mali",
        "Mali",
        "Mali",
        "Mali",
        "Мали"
    ),
    MM(
        "Myanmar (Burma)",
        "Myanmar (Birmania)",
        "Myanmar (Birmanie)",
        "Mianmar (Birmânia)",
        "Мьянма (Бирма)"
    ),
    MN("Mongolia", "Mongolia", "Mongolie", "Mongólia", "Монголия"), MQ(
        "Martinique",
        "Martinica",
        "Martinique",
        "Martinica",
        "Мартиника"
    ),
    MR("Mauritania", "Mauritania", "Mauritanie", "Mauritânia", "Мавритания"), MS(
        "Montserrat",
        "Montserrat",
        "Montserrat",
        "Montserrat",
        "Монтсеррат"
    ),
    MT("Malta", "Malta", "Malte", "Malta", "Мальта"), MU(
        "Mauritius",
        "Mauricio",
        "Maurice",
        "Maurício",
        "Маврикий"
    ),
    MV("Maldives", "Maldivas", "Maldives", "Maldivas", "Мальдивы"), MW(
        "Malawi",
        "Malawi",
        "Malawi",
        "Malawi",
        "Малави"
    ),
    MX("Mexico", "Mexico", "Mexique", "México", "Мексика"), MY(
        "Malaysia",
        "Malasia",
        "Malaisie",
        "Malásia",
        "Малайзия"
    ),
    MZ("Mozambique", "Mozambique", "Mozambique", "Moçambique", "Мозамбик"), NA(
        "Namibia",
        "Namibia",
        "Namibie",
        "Namíbia",
        "Намибия"
    ),
    NC(
        "New Caledonia",
        "Nueva Caledonia",
        "Nouvelle Calédonie",
        "Nova Caledônia",
        "Новая Каледония"
    ),
    NE("Niger", "Níger", "Niger", "Níger", "Нигер"), NG(
        "Nigeria",
        "Nigeria",
        "Nigeria",
        "Nigéria",
        "Нигерия"
    ),
    NI("Nicaragua", "Nicaragua", "Nicaragua", "Nicarágua", "Никарагуа"), NL(
        "Netherlands",
        "Países Bajos",
        "Pays-Bas",
        "Países Baixos",
        "Нидерланды"
    ),
    NO("Norway", "Noruega", "Norvège", "Noruega", "Норвегия"), NP(
        "Nepal",
        "Nepal",
        "Népal",
        "Nepal",
        "Непал"
    ),
    NR("Nauru", "Nauru", "Nauru", "Nauru", "Науру"), NU("Niue", "Niue", "Niue", "Niue", "Ниуэ"), NZ(
        "New Zealand",
        "Nueva Zelanda",
        "Nouvelle-Zélande",
        "Nova Zelândia",
        "Новая Зеландия"
    ),
    OM("Oman", "Omán", "Oman", "Omã", "Оман"), PA(
        "Panama",
        "Panamá",
        "Panama",
        "Panamá",
        "Панама"
    ),
    PE("Peru", "Perú", "Pérou", "Peru", "Перу"), PF(
        "French Polynesia",
        "Polinesia francés",
        "Polynésie française",
        "Polinésia Francesa",
        "Французская Полинезия"
    ),
    PG(
        "Papua New Guinea",
        "Papúa Nueva Guinea",
        "Papouasie Nouvelle Guinée",
        "Papua Nova Guiné",
        "Папуа — Новая Гвинея"
    ),
    PH("Philippines", "Filipinas", "Philippines", "Filipinas", "Филиппины"), PK(
        "Pakistan",
        "Pakistán",
        "Pakistan",
        "Paquistão",
        "Пакистан"
    ),
    PL("Poland", "Polonia", "Pologne", "Polônia", "Польша"), PR(
        "Puerto Rico",
        "Puerto Rico",
        "Porto Rico",
        "Porto Rico",
        "Пуэрто-Рико"
    ),
    PS(
        "Palestinian Territories",
        "Territorios Palestinos",
        "Territoires palestiniens",
        "Territórios palestinos",
        "Палестинские территории"
    ),
    PT("Portugal", "Portugal", "le Portugal", "Portugal", "Португалия"), PW(
        "Palau",
        "Palau",
        "Palau",
        "Palau",
        "Палау"
    ),
    PY("Paraguay", "Paraguay", "Le Paraguay", "Paraguai", "Парагвай"), QA(
        "Qatar",
        "Katar",
        "Qatar",
        "Catar",
        "Катар"
    ),
    RO("Romania", "Rumania", "Roumanie", "Roménia", "Румыния"), RS(
        "Serbia",
        "Serbia",
        "Serbie",
        "Sérvia",
        "Сербия"
    ),
    RU("Russia", "Rusia", "Russie", "Rússia", "Россия"), RW(
        "Rwanda",
        "Ruanda",
        "Rwanda",
        "Ruanda",
        "Руанда"
    ),
    SA(
        "Saudi Arabia",
        "Arabia Saudita",
        "Arabie Saoudite",
        "Arábia Saudita",
        "Саудовская Аравия"
    ),
    SB(
        "Solomon Islands",
        "Islas Salomón",
        "îles Salomon",
        "Ilhas Salomão",
        "Соломоновы Острова"
    ),
    SC(
        "Seychelles",
        "Seychelles",
        "les Seychelles",
        "Seychelles",
        "Сейшельские Острова"
    ),
    SD("Sudan", "Sudán", "Soudan", "Sudão", "Судан"), SE(
        "Sweden",
        "Suecia",
        "Suède",
        "Suécia",
        "Швеция"
    ),
    SG("Singapore", "Singapur", "Singapour", "Cingapura", "Сингапур"), SH(
        "St. Helena",
        "Santa helena",
        "Sainte-Hélène",
        "Santa Helena",
        "о-в Св. Елены"
    ),
    SI("Slovenia", "Eslovenia", "La Slovénie", "Eslovênia", "Словения"), SK(
        "Slovakia",
        "Eslovaquia",
        "Slovaquie",
        "Eslováquia",
        "Словакия"
    ),
    SL(
        "Sierra Leone",
        "Sierra Leona",
        "Sierra Leone",
        "Serra Leoa",
        "Сьерра-Леоне"
    ),
    SM("San Marino", "San Marino", "Saint Marin", "San Marino", "Сан-Марино"), SN(
        "Senegal",
        "Senegal",
        "Sénégal",
        "Senegal",
        "Сенегал"
    ),
    SO("Somalia", "Somalia", "Somalie", "Somália", "Сомали"), SR(
        "Suriname",
        "Surinam",
        "Suriname",
        "Suriname",
        "Суринам"
    ),
    SS(
        "South Sudan",
        "Sudán del Sur",
        "Soudan du sud",
        "Sudão do Sul",
        "Южный Судан"
    ),
    ST(
        "São Tomé & Príncipe",
        "Santo Tomé y Príncipe",
        "São Tomé et Príncipe",
        "São Tomé e Príncipe",
        "Сан-Томе и Принсипи"
    ),
    SV("El Salvador", "El Salvador", "Le Salvador", "El Salvador", "Сальвадор"), SY(
        "Syria",
        "Siria",
        "Syrie",
        "Síria",
        "Сирия"
    ),
    SZ("Swaziland", "Suazilandia", "Swaziland", "Suazilândia", "Эсватини"), TD(
        "Chad",
        "Chad",
        "Tchad",
        "Chade",
        "Чад"
    ),
    TG("Togo", "Togo", "Togo", "Togo", "Того"), TH(
        "Thailand",
        "Tailandia",
        "Thaïlande",
        "Tailândia",
        "Таиланд"
    ),
    TJ("Tajikistan", "Tayikistan", "Tadjikistan", "Tajiquistão", "Таджикистан"), TL(
        "Timor-Leste",
        "Timor-Leste",
        "Timor-Leste",
        "Timor-Leste",
        "Восточный Тимор"
    ),
    TM(
        "Turkmenistan",
        "Turkmenistán",
        "Turkménistan",
        "Turcomenistão",
        "Туркменистан"
    ),
    TN("Tunisia", "Túnez", "Tunisie", "Tunísia", "Тунис"), TO(
        "Tonga",
        "Tonga",
        "Tonga",
        "Tonga",
        "Тонга"
    ),
    TR("Turkey", "Turquía", "Turkie", "Turquia", "Турция"), TT(
        "Trinidad & Tobago",
        "Trinidad y Tobago",
        "Trinité et Tobago",
        "Trinidad e Tobago",
        "Тринидад и Тобаго"
    ),
    TV("Tuvalu", "Tuvalu", "Tuvalu", "Tuvalu", "Тувалу"), TZ(
        "Tanzania",
        "Tanzania",
        "Tanzanie",
        "Tanzânia",
        "Танзания"
    ),
    UA("Ukraine", "Ucrania", "Ukraine", "Ucrânia", "Украина"), UG(
        "Uganda",
        "Uganda",
        "Ouganda",
        "Uganda",
        "Уганда"
    ),
    US(
        "United States",
        "Estados Unidos",
        "États Unis",
        "Estados Unidos",
        "Соединенные Штаты"
    ),
    UY("Uruguay", "Uruguay", "Uruguay", "Uruguai", "Уругвай"), UZ(
        "Uzbekistan",
        "Uzbekistán",
        "Ouzbekistan",
        "Uzbequistão",
        "Узбекистан"
    ),
    VC(
        "St. Vincent & Grenadines",
        "San Vicente y Granadinas",
        "Saint-Vincent et les Grenadines",
        "São Vicente e Granadinas",
        "Сент-Винсент и Гренадины"
    ),
    VE("Venezuela", "Venezuela", "Venezuela", "Venezuela", "Венесуэла"), VI(
        "U.S. Virgin Islands",
        "Islas Vírgenes de EE.UU",
        "Îles Vierges américaines",
        "Ilhas Virgens dos EUA",
        "Виргинские о-ва (США)"
    ),
    VN("Vietnam", "Vietnam", "Vietnam", "Vietnã", "Вьетнам"), VU(
        "Vanuatu",
        "Vanuatu",
        "Vanuatu",
        "Vanuatu",
        "Вануату"
    ),
    WF(
        "Wallis & Futuna",
        "Wallis y Futuna",
        "Wallis et Futuna",
        "Wallis e Futuna",
        "Уоллис и Футуна"
    ),
    WS("Samoa", "Samoa", "Samoa", "Samoa", "Самоа"), YE(
        "Yemen",
        "Yemen",
        "Yémen",
        "Iémen",
        "Йемен"
    ),
    YT("Mayotte", "Mayotte", "Mayotte", "Mayotte", "Майотта"), ZA(
        "South Africa",
        "Sudáfrica",
        "Afrique du Sud",
        "África do Sul",
        "Южно-Африканская Республика"
    ),
    ZM("Zambia", "Zambia", "Zambie", "Zâmbia", "Замбия"), ZW(
        "Zimbabwe",
        "Zimbabue",
        "Zimbabwe",
        "Zimbábue",
        "Зимбабве"
    );

    val countryNames: Map<String, String>

    init {
        countryNames =
            mapOf("en" to enName, "es" to esName, "fr" to frName, "pt" to ptName, "ru" to ruName)
    }
}