package com.getmati.mati_sdk.models.clean

import kotlinx.parcelize.Parcelize

@Parcelize
internal data class CustomDoc(
    override val id: String,
    val name: String,
    val description: String,
    val skippable: Boolean,
    val hintImageUrls: List<String>,
    val pages: Int,
    val singleFile: Boolean,
    override var country: Country? = null,
    override var region: String? = null
) : Document {
    override val bothSidesNeeded get() = pages == 2
    override val analyticsId get() = "customDoc"

    companion object{
        const val PREFIX_CUSTOM_DOCUMENT = "custom-"
        val analyticsId get() = "customDoc"
    }
}