package com.getmati.mati_sdk.models.clean

import kotlinx.parcelize.Parcelize

@Parcelize
internal data class DrivingLicense(
    override var country: Country? = null,
    override var region: String? = null
) : Document {

    override val id get() = "driving-license"
    override val bothSidesNeeded get() = true
    override val analyticsId get() = "drivingLicense"

    companion object{
        const val DOC_ID_DRIVING_LICENSE = "driving-license"
        val analyticsId get() = "drivingLicense"
    }
}