package com.getmati.mati_sdk.models.clean

import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import com.getmati.mati_sdk.R

internal enum class Language(
    val id: String,
    val iso: String,
    @get:StringRes val titleRes: Int,
    @get:DrawableRes val imageRes: Int
) {
    GERMAN("de", "de_DE", R.string.title_german, R.drawable.ic_flag_germany),
    ENGLISH("en", "en_US", R.string.title_english, R.drawable.ic_flag_england),
    SPANISH("es", "es_MX", R.string.title_spanish, R.drawable.ic_flag_spain),
    FRENCH("fr", "fr_FR", R.string.title_french, R.drawable.ic_flag_france),
    ITALIAN("it", "it_IT", R.string.title_italian, R.drawable.ic_flag_italy),
    PORTUGUESE("pt", "pt_PT", R.string.title_portuguese, R.drawable.ic_flag_brazil), //Portuguese flag was changed to Brazil flag HMS-158
    RUSSIAN("ru", "ru_RU", R.string.title_russian, R.drawable.ic_flag_russia),
    TURKISH("tr", "tr_TR", R.string.title_turkish, R.drawable.ic_flag_turkey),
    POLISH("pl", "pl_PL", R.string.title_polish, R.drawable.ic_flag_poland),
    THAI("th", "th_TH", R.string.title_thai, R.drawable.ic_flag_thailand);

    companion object {
        @JvmStatic
        fun fromId(pId: String?): Language? {
            return values().firstOrNull { it.id == pId }
        }
    }
}