package com.getmati.mati_sdk.models.clean

import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import com.getmati.mati_sdk.R

internal enum class MediaVerificationError(val id: String, @DrawableRes val iconId: Int, @StringRes val title: Int, @StringRes val subtitle: Int) {
    INPUT_NOT_FOUND("input.not.found", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image
    INPUT_SKIPPED("input.skipped", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image
    INPUT_LOCKED("input.locked", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image
    MEDIA_NOT_FOUND("media.not.found", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image
    VALIDATION_ERROR("validation.error", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image

    DOCUMENT_LARGE_IMAGE("413", R.drawable.ic_large_file_error, R.string.label_large_image_error,R.string.label_select_image_smaller_then),
    DOCUMENT_COUNTRY_MISMATCH("documentPhoto.countryMismatch", R.drawable.ic_error_country_mismatch, R.string.label_country_mismatch_error_title,R.string.label_country_mismatch_error_description),
    DOCUMENT_NO_FACE("documentPhoto.noFace", R.drawable.ic_noface_doc_error, R.string.label_doc_face_not_detected,R.string.label_make_sure_face_is_visible),
    DOCUMENT_BLURRY_TEXT("documentPhoto.blurryText", R.drawable.ic_notext_doc_error, R.string.label_doc_text_not_detected,R.string.label_make_sure_picture_is_clear),
    DOCUMENT_BAD_TEXT("documentPhoto.badText", R.drawable.ic_notext_doc_error, R.string.label_doc_text_not_detected,R.string.label_make_sure_picture_is_clear),
    DOCUMENT_SMALL_IMAGE_SIZE("documentPhoto.smallImageSize", R.drawable.ic_large_file_error, R.string.error_too_small_image_title, R.string.label_select_image_larger_then),
    BITMAP_DECODING_ERROR("bitmap.decodingError", R.drawable.ic_large_file_error, R.string.label_something_went_wrong, R.string.label_selected_image_decoding_error),
    DOCUMENT_PDF_TRANSFORMATION_FAILURE("pdf.transformationError", R.drawable.ic_large_file_error, R.string.error_pdf_transformation, R.string.label_pdf_transformation_failed),
    DOCUMENT_UNREADABLE_DATA("documentPhoto.noDocument", R.drawable.ic_nofaceindocerrorimage, R.string.label_nodocument_error_title,R.string.label_nodocument_error_description),
    DOCUMENT_IDENTICAL_IMAGES("documentPhoto.identicalImages", R.drawable.ic_similar_doc_error, R.string.baseErrorScreenfileMatchErrortitle,R.string.baseErrorScreenfileMatchErrordescription),
    DOCUMENT_SIMILAR_IMAGES("documentPhoto.similarImages", R.drawable.ic_similar_doc_error, R.string.baseErrorScreenfileMatchErrortitle,R.string.baseErrorScreenfileMatchErrordescription),
    DOCUMENT_SCREEN_PHOTO("documentPhoto.screenPhoto", R.drawable.ic_physical_doc_error, R.string.label_physical_error_title,R.string.label_physical_error_description),
    DOCUMENT_GRAYSCALE("documentPhoto.grayscaleImage", R.drawable.ic_physical_doc_error, R.string.label_physical_error_title,R.string.label_physical_error_description),


    SELFIE_PHOTO_MULTIPLE_FACES("selfiePhoto.multipleFaces", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image
    SELFIE_PHOTO_NO_FACE("selfiePhoto.noFace", R.drawable.ic_noface_selfie_error, R.string.label_biometric_face_not_detected, R.string.label_noface_descr_document_error),
    SELFIE_PHOTO_MASK_DETECTED("selfiePhoto.maskDetected", R.drawable.ic_noface_selfie_error, R.string.error_title_biometric_mask_detected, R.string.error_desc_biometric_mask_detected),

    SELFIE_VIDEO_CONVERSION_FAILED("selfieVideo.conversionFailed", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image
    SELFIE_VIDEO_MULTIPLE_FACES("selfieVideo.multipleFaces", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet), // FIXME Default text / image
    SELFIE_VIDEO_NO_FACE("selfieVideo.noFace", R.drawable.ic_noface_selfie_error, R.string.label_biometric_face_not_detected, R.string.label_noface_descr_document_error),
    SELFIE_VIDEO_MASK_DETECTED("selfieVideo.maskDetected", R.drawable.ic_noface_selfie_error, R.string.error_title_biometric_mask_detected, R.string.error_desc_biometric_mask_detected),

    VOICELIVENESS_TIMEOUT("VoiceLivenessTimeout", R.drawable.ic_timeout_error, R.string.label_error_vl_timeout, 0),
    VOICELIVENESS_NOFACE("voiceVideo.noFace", R.drawable.ic_noface_vl_error, R.string.label_error_vl_noface,R.string.label_error_vl_noface_description),
    VOICELIVENESS_MASK_DETECTED("voiceVideo.maskDetected", R.drawable.ic_noface_selfie_error, R.string.error_title_biometric_mask_detected, R.string.error_desc_biometric_mask_detected),

    SYSTEM_INTERNAL_ERROR("system.internalError", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet),
    OTHER("other", R.drawable.ic_error_other, R.string.label_something_went_wrong, R.string.label_check_your_internet),

    INVALID_EMAIL("emailAddressWithConfirmationCode.invalidEmail", R.drawable.ic_email_verification_step, R.string.error_title_invalid_email, R.string.error_description_invalid_email),
    EMAIL_RESEND_LOCKED("emailAddressWithConfirmationCode.resendLocked", R.drawable.ic_email_verification_step, R.string.error_title_email_resend_locked, R.string.error_description_email_resend_locked),
    EMAIL_TOO_MANY_RESENDS("emailAddressWithConfirmationCode.tooManyResends", R.drawable.ic_email_verification_step, R.string.error_title_too_many_resends, R.string.error_description_too_many_resends),
    EMAIL_WRONG_CONFIRMATION_CODE("emailAddressWithConfirmationCode.wrongConfirmationCode", R.drawable.ic_email_verification_step, R.string.error_title_wrong_email_confirmation_code, R.string.error_description_wrong_email_confirmation_code),
    EMAIL_CONFIRMATION_CODE_TOO_MANY_ATTEMPTS("emailAddressWithConfirmationCode.tooManyAttempts", R.drawable.ic_email_verification_step, R.string.error_title_email_confirmation_code_too_many_attempts, R.string.error_description_email_confirmation_code_too_many_attempts),


    //TODO Phone errors must be handled properly
    PHONE_WRONG_CONFIRMATION_CODE("phoneNumberWithConfirmationCode.wrongConfirmationCode", R.drawable.ic_phone, R.string.label_sms_check_code_incorrect, R.string.label_sms_check_code_incorrect),
    PHONE_RESEND_LOCKED("phoneNumberWithConfirmationCode.resendLocked", R.drawable.ic_phone, R.string.label_sms_check_code_incorrect, R.string.label_sms_check_code_incorrect),
    PHONE_TOO_MANY_ATTEMPTS("phoneNumberWithConfirmationCode.tooManyAttempts", R.drawable.ic_phone, R.string.label_sms_check_code_incorrect, R.string.label_sms_check_code_incorrect),
    PHONE_TOO_MANY_RESENDS("phoneNumberWithConfirmationCode.tooManyResends", R.drawable.ic_phone, R.string.label_sms_check_code_incorrect, R.string.label_sms_check_code_incorrect),
    PHONE_NOT_ENOUGH_PARAMS("phoneNumberWithConfirmationCode.notEnoughParams", R.drawable.ic_phone, R.string.label_sms_check_code_incorrect, R.string.label_sms_check_code_incorrect),
    PHONE_INVALID_PHONE_NUMBER("phoneNumberWithConfirmationCode.invalidPhoneNumber", R.drawable.ic_phone, R.string.label_sms_check_code_incorrect, R.string.label_sms_check_code_incorrect),
    // Ip restrictions
    CONNECTION_DATA_RESTRICTED("connectionData.restricted", R.drawable.ic_country_restricted, R.string.label_ip_title, R.string.label_ip_description),
    CONNECTION_DATA_VPM_DETECTED("connectionData.vpnDetected", R.drawable.ic_vpn_detected, R.string.label_vpn_title, R.string.label_vpn_description);

    companion object {
        fun byId(id: String?) : MediaVerificationError {
            return id?.let { values().firstOrNull { it.id == id }} ?: OTHER
        }
    }
}
