package com.getmati.mati_sdk.models.clean

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

@Parcelize
internal data class NationalId(
    override var country: Country? = null,
    override var region: String? = null,
    val metadata: DocMetadata? = null
) : Document {


    override fun exportMetaData(): String? {
        return metadata?.let{ Json.encodeToString(it.toDocMetadataDto()) }
    }


    override val id get() = "national-id"
    override val bothSidesNeeded get() = true
    override val analyticsId get() = "nationalId"

    companion object{
        const val DOC_ID_NATIONAL_ID = "national-id"
        val analyticsId get() = "nationalId"
    }
}

@Parcelize
internal data class DocMetadata(
    val taxpayerNumber: String
    ):Parcelable

@Serializable
internal data class DocMetadataDto(
    @SerialName("taxpayerNumber")
    val taxpayerNumber: String
    )

internal fun DocMetadata.toDocMetadataDto() = DocMetadataDto(taxpayerNumber)