package com.getmati.mati_sdk.models.clean

import kotlinx.parcelize.Parcelize

@Parcelize
internal data class Passport(
    override var country: Country? = null,
    override var region: String? = null
) : Document {

    override val id get() = "passport"
    override val bothSidesNeeded get() = false
    override val analyticsId get() = "passport"

    companion object{
        const val DOC_ID_PASSPORT = "passport"
        val analyticsId get() = "passport"
    }
}