package com.getmati.mati_sdk.models.clean

import kotlinx.parcelize.Parcelize

@Parcelize
internal data class ProofOfResidency(
    val porType: PorType? = null,
    override var country: Country? = null,
    override var region: String? = null
) : Document {

    override val id get() = "proof-of-residency"
    override val bothSidesNeeded get() = false
    override val analyticsId get() = "proofOfResidency"

    companion object{
        const val DOC_ID_PROOF_OF_RESIDENCY = "proof-of-residency"
        val analyticsId get() = "proofOfResidency"
    }
}