package com.getmati.mati_sdk.models.clean

internal enum class Province(val title: String) {
    AB("Alberta"), BC("British Columbia"), MB("Manitoba"), NB("New Brunswick"), NL("Newfoundland and Labrador"), NS("Nova Scotia"), NT("Northwest Territories"), NU("Nunavut"), ON("Ontario"), PE("Prince Edward Island"), QC("Québec"), SK("Saskatchewan"), YT("Yukon");

    companion object {
        fun codeFromTitle(pId: String?): String? {
            return values().firstOrNull{it.title == pId}?.name
        }
    }
}