package com.getmati.mati_sdk.models.clean

import com.getmati.mati_sdk.models.clean.input.Input
import com.getmati.mati_sdk.models.clean.verification.VerificationFlow
import com.getmati.mati_sdk.models.clean.verification.VerificationResult
import com.getmati.mati_sdk.models.clean.web_config.WebContainerConfig

sealed class SocketEvent {

    internal object DummySocketEvent : SocketEvent()

    internal data class VerificationResultEvent(val verificationResult: VerificationResult) : SocketEvent()

    internal data class RoomJoined(
        val inputs: List<Input>,
        val verificationFlow: VerificationFlow,
        val webContainerConfig: List<WebContainerConfig>
    ) : SocketEvent()

    internal class CountriesReceived(val countries: List<Country>) : SocketEvent()
}