package com.getmati.mati_sdk.models.clean.input

import android.os.Parcelable
import kotlinx.parcelize.IgnoredOnParcel
import kotlinx.parcelize.Parcelize


@Parcelize
internal data class Input(val id: String,
                          val status: InputStatus?,
                          val group: Int? = null,
                          val inputData: InputData? = null,
                          val error: InputError? = null): Parcelable

@Parcelize
internal data class InputError(val code: String,
                               val optional: Boolean,
                               val inputErrorDetail: InputErrorDetail? = null): Parcelable {
    @IgnoredOnParcel
    val isCritical = !optional
}

@Parcelize
internal data class InputErrorDetail(val text: String?, val attemptsLeft: Int?) : Parcelable

@Parcelize
internal data class InputData(val inputDataPages: InputDataPages? = null,
                              val countryCode: String? = null) : Parcelable

@Parcelize
internal data class InputDataPages(val frontSuccessful: Boolean) : Parcelable

internal enum class InputStatus(val code: Int) {
    SUCCESS(200),
    IN_PROGRESS(100),
    ERROR(0)
}