package com.getmati.mati_sdk.models.clean.verification

import android.os.Parcelable
import com.getmati.mati_sdk.models.clean.ip_validation.IpValidation
import com.getmati.mati_sdk.ui.BiometryType
import com.getmati.mati_sdk.ui.BiometryUpload
import com.getmati.mati_sdk.ui.DocumentVerificationStep
import com.getmati.mati_sdk.ui.VerificationStep
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.RawValue

@Parcelize
internal data class VerificationFlow(
    val id: String,
    val name: String,
    val verificationSteps: @RawValue List<VerificationStep>,
    val denyUploadsFromMobileGallery: Boolean = false,
    val pinnedCountries: List<String>? = null,
    val supportedCountries: List<String> = emptyList(),
    val logoUrl: String? = null,
    val ipValidation: IpValidation?
) : Parcelable

internal val VerificationFlow.biometryType: String
    get() = verificationSteps
        .firstOrNull { it is BiometryUpload }
        ?.let { it as BiometryUpload }
        ?.biometryType?.id
        ?: BiometryType.NONE.id

internal val VerificationFlow.documentUploadSteps
    get() = verificationSteps
        .filterIsInstance<DocumentVerificationStep>()
        .map { it.acceptableDocuments }