package com.getmati.mati_sdk.models.socket.response.join_room

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject

@Serializable
internal data class VerificationFlowResponse(
    @SerialName("_id")
    val id: String? = null,
    @SerialName("name")
    val name: String? = null,
    @SerialName("verificationSteps")
    val verificationSteps: List<List<String>>? = null,
    @SerialName("verificationPatterns")
    val verificationPatternsResponse: VerificationPatternsResponse? = null,
    @SerialName("electronicSignature")
    val electronicSignatureResponse: ElectronicSignatureResponse? = null,
    @SerialName("customDocumentConfig")
    val customDocumentConfig: JsonObject? = null,
    @SerialName("denyUploadsFromMobileGallery")
    val denyUploadsFromMobileGallery: Boolean? = null,
    @SerialName("supportedCountries")
    val supportedCountries: List<String>? = null,
    @SerialName("pinnedCountries")
    val pinnedCountries: List<String>? = null,
    @SerialName("logoUrl")
    val logoUrl: String? = null,
    @SerialName("ipValidation")
    val ipValidationResponse: IpValidationResponse? = null
)

@Serializable
internal data class VerificationPatternsResponse(
    @SerialName("electronic-signature-document-validation")
    val electronicSignatureDocumentValidation: Boolean,
    @SerialName("biometrics")
    val biometrics: String,
    @SerialName("phone-ownership-validation")
    val phoneOwnershipValidation: String,
    @SerialName("email-ownership-validation")
    val emailOwnershipValidation: String,
    @SerialName("financial-information-bank-accounts-retrieving")
    val bankAccountRetrieval: Boolean,
    @SerialName("financial-information-payroll-accounts-retrieving")
    val payrollAccountRetrieval: Boolean,
    @SerialName("financial-information-work-accounts-retrieving")
    val workAccountRetrieval: Boolean,
)

@Serializable
internal data class ElectronicSignatureResponse(
    @SerialName("templates")
    val electronicSignatureTemplatesResponse: ElectronicSignatureTemplatesResponse? = null,
)

@Serializable
internal data class ElectronicSignatureTemplatesResponse(
    @SerialName("order")
    val order: List<String>,
    @SerialName("list")
    val documents: List<ElectronicSignatureDocumentListResponse>,
)

@Serializable
internal data class ElectronicSignatureDocumentListResponse(
    @SerialName("id")
    val id: String,
    @SerialName("originalDocument")
    val originalDocument: ElectronicSignatureOriginalDocumentResponse,
)

@Serializable
internal data class ElectronicSignatureOriginalDocumentResponse(
    @SerialName("publicUrl")
    val publicUrl: String? = null
)

@Serializable
internal data class IpValidationResponse(
    @SerialName("allowedRegions")
    val allowedRegions: List<AllowedRegionsCountryResponse>? = null
)

@Serializable
internal data class AllowedRegionsCountryResponse(
    @SerialName("country")
    val country: String? = null
)



