package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.transport.AsyncHttpTransport;
import com.getmati.mati_sdk.sentry.io.sentry.transport.ITransport;
import com.getmati.mati_sdk.sentry.io.sentry.transport.RateLimiter;
import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;

import org.jetbrains.annotations.NotNull;

/** Creates {@link AsyncHttpTransport}. */
public final class AsyncHttpTransportFactory implements ITransportFactory {

  @Override
  public @NotNull
  ITransport create(
          final @NotNull SentryOptions options, final @NotNull RequestDetails requestDetails) {
    Objects.requireNonNull(options, "options is required");
    Objects.requireNonNull(requestDetails, "requestDetails is required");

    return new AsyncHttpTransport(
        options, new RateLimiter(options.getLogger()), options.getTransportGate(), requestDetails);
  }
}
