package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * Arbitrary data used in {@link SamplingContext} to determine if transaction is going to be
 * sampled.
 */
public final class CustomSamplingContext {
  private final @NotNull Map<String, Object> data = new HashMap<>();

  public void set(final @NotNull String key, final @Nullable Object value) {
    Objects.requireNonNull(key, "key is required");
    this.data.put(key, value);
  }

  public @Nullable Object get(final @NotNull String key) {
    Objects.requireNonNull(key, "key is required");
    return this.data.get(key);
  }

  public @NotNull Map<String, Object> getData() {
    return data;
  }
}
