package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.protocol.Contexts;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Request;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

import java.util.List;

public interface ITransaction extends ISpan {

  /**
   * Sets transaction name.
   *
   * @param name - transaction name
   */
  void setName(@NotNull String name);

  /**
   * Returns transaction name.
   *
   * @return transaction name
   */
  @NotNull
  String getName();

  @NotNull
  @TestOnly
  List<Span> getSpans();

  /**
   * Returns if transaction is sampled.
   *
   * @return is sampled
   */
  @Nullable
  Boolean isSampled();

  /**
   * Returns the latest span that is not finished.
   *
   * @return span or null if not found.
   */
  @Nullable
  Span getLatestActiveSpan();

  /**
   * Returns transaction's event id.
   *
   * @return the event id
   */
  @NotNull
  SentryId getEventId();

  /**
   * Attaches request information to the transaction.
   *
   * @param request the request
   * @deprecated use {@link Scope#setRequest(Request)}
   */
  @Deprecated
  void setRequest(@Nullable Request request);

  /**
   * Returns the request information from the transaction
   *
   * @return the request or {@code null} if not set
   * @deprecated use {@link Scope#getRequest()}
   */
  @Nullable
  @Deprecated
  Request getRequest();

  /**
   * Returns contexts associated with the transaction.
   *
   * @return the contexts
   * @deprecated use {@link Scope#getContexts()}
   */
  @NotNull
  @Deprecated
  Contexts getContexts();
}
