package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.transport.ITransport;

import org.jetbrains.annotations.NotNull;

/** Creates instances of {@link ITransport}. */
public interface ITransportFactory {
  /**
   * Creates an instance of {@link ITransport}.
   *
   * @param options sentry configuration that can be used to create transport
   * @param requestDetails http request properties that must be applied to http request invoked by
   *     the transport
   * @return the transport
   */
  @NotNull
  ITransport create(
          final @NotNull SentryOptions options, final @NotNull RequestDetails requestDetails);
}
