package com.getmati.mati_sdk.sentry.io.sentry;

import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;

public final class IpAddressUtils {
  static final String DEFAULT_IP_ADDRESS = "{{auto}}";
  private static final List<String> DEFAULT_IP_ADDRESS_VALID_VALUES =
      Arrays.asList(DEFAULT_IP_ADDRESS, "{{ auto }}");

  private IpAddressUtils() {}

  public static boolean isDefault(final @Nullable String ipAddress) {
    return ipAddress != null && DEFAULT_IP_ADDRESS_VALID_VALUES.contains(ipAddress);
  }
}
