package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.protocol.Contexts;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.Request;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

public final class NoOpTransaction implements ITransaction {

  private static final NoOpTransaction instance = new NoOpTransaction();

  private NoOpTransaction() {}

  public static NoOpTransaction getInstance() {
    return instance;
  }

  @Override
  public void setName(@NotNull String name) {}

  @Override
  public @NotNull String getName() {
    return "";
  }

  @Override
  public @NotNull
  ISpan startChild(final @NotNull String operation) {
    return NoOpSpan.getInstance();
  }

  @Override
  public @NotNull
  ISpan startChild(
      final @NotNull String operation, final @Nullable String description) {
    return NoOpSpan.getInstance();
  }

  /** @deprecated use {@link Scope#setRequest(Request)} */
  @Override
  @Deprecated
  public void setRequest(@Nullable Request request) {}

  /** @deprecated use {@link Scope#getRequest()} */
  @Override
  @Deprecated
  @SuppressWarnings("InlineMeSuggester")
  public @Nullable
  Request getRequest() {
    return null;
  }

  /** @deprecated use {@link Scope#getContexts()} */
  @Override
  @Deprecated
  @SuppressWarnings("InlineMeSuggester")
  public @NotNull
  Contexts getContexts() {
    return new Contexts();
  }

  @Override
  public @Nullable String getDescription() {
    return null;
  }

  @Override
  public @NotNull List<Span> getSpans() {
    return Collections.emptyList();
  }

  @Override
  public @Nullable
  Span getLatestActiveSpan() {
    return null;
  }

  @Override
  public @NotNull
  SentryId getEventId() {
    return SentryId.EMPTY_ID;
  }

  @Override
  public boolean isFinished() {
    return true;
  }

  @Override
  public @NotNull
  SentryTraceHeader toSentryTrace() {
    return new SentryTraceHeader(SentryId.EMPTY_ID, SpanId.EMPTY_ID, false);
  }

  @Override
  public void finish() {}

  @Override
  public void finish(@Nullable SpanStatus status) {}

  @Override
  public void setOperation(@NotNull String operation) {}

  @Override
  public @NotNull String getOperation() {
    return "";
  }

  @Override
  public void setDescription(@Nullable String description) {}

  @Override
  public void setStatus(@Nullable SpanStatus status) {}

  @Override
  public @Nullable
  SpanStatus getStatus() {
    return null;
  }

  @Override
  public void setThrowable(@Nullable Throwable throwable) {}

  @Override
  public @Nullable Throwable getThrowable() {
    return null;
  }

  @Override
  public @NotNull
  SpanContext getSpanContext() {
    return new SpanContext(SentryId.EMPTY_ID, SpanId.EMPTY_ID, "op", null, null);
  }

  @Override
  public void setTag(@NotNull String key, @NotNull String value) {}

  @Override
  public @Nullable String getTag(@NotNull String key) {
    return null;
  }

  @Override
  public @Nullable Boolean isSampled() {
    return null;
  }
}
