package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.transport.ITransport;
import com.getmati.mati_sdk.sentry.io.sentry.transport.NoOpTransport;

import org.jetbrains.annotations.NotNull;

public final class NoOpTransportFactory implements ITransportFactory {

  private static final NoOpTransportFactory instance = new NoOpTransportFactory();

  public static NoOpTransportFactory getInstance() {
    return instance;
  }

  private NoOpTransportFactory() {}

  @Override
  public @NotNull
  ITransport create(
          final @NotNull SentryOptions options, final @NotNull RequestDetails requestDetails) {
    return NoOpTransport.getInstance();
  }
}
