package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.protocol.SdkVersion;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;

import org.jetbrains.annotations.Nullable;

public final class SentryEnvelopeHeader {
  // Event Id must be set if the envelope holds an event, or an item that is related to the event
  // (e.g: attachments, user feedback)
  private final @Nullable
  SentryId eventId;

  private final @Nullable
  SdkVersion sdkVersion;

  public SentryEnvelopeHeader(
          final @Nullable SentryId eventId, final @Nullable SdkVersion sdkVersion) {
    this.eventId = eventId;
    this.sdkVersion = sdkVersion;
  }

  public SentryEnvelopeHeader(final @Nullable SentryId eventId) {
    this(eventId, null);
  }

  public SentryEnvelopeHeader() {
    this(new SentryId());
  }

  public @Nullable
  SentryId getEventId() {
    return eventId;
  }

  public @Nullable
  SdkVersion getSdkVersion() {
    return sdkVersion;
  }
}
