package com.getmati.mati_sdk.sentry.io.sentry;

import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryTransaction;

public enum SentryItemType {
  Session("session"),
  Event("event"), // DataCategory.Error
  UserFeedback("user_report"), // Sentry backend still uses user_report
  Attachment("attachment"),
  Transaction("transaction"),
  Unknown("__unknown__"); // DataCategory.Unknown

  private final String itemType;

  public static SentryItemType resolve(Object item) {
    if (item instanceof SentryEvent) {
      return Event;
    } else if (item instanceof SentryTransaction) {
      return Transaction;
    } else if (item instanceof com.getmati.mati_sdk.sentry.io.sentry.Session) {
      return Session;
    } else {
      return Attachment;
    }
  }

  SentryItemType(final String itemType) {
    this.itemType = itemType;
  }

  public String getItemType() {
    return itemType;
  }
}
