package com.getmati.mati_sdk.sentry.io.sentry.adapters;

import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryId;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Type;

public final class SentryIdDeserializerAdapter implements JsonDeserializer<SentryId> {

  private final @NotNull
  SentryOptions options;

  public SentryIdDeserializerAdapter(final @NotNull SentryOptions options) {
    this.options = options;
  }

  @Override
  public @Nullable
  SentryId deserialize(
      final @Nullable JsonElement json,
      final @NotNull Type typeOfT,
      final @NotNull JsonDeserializationContext context)
      throws JsonParseException {
    try {
      return json == null ? null : new SentryId(json.getAsString());
    } catch (Exception e) {
      options.getLogger().log(SentryLevel.ERROR, "Error when deserializing SentryId", e);
    }
    return null;
  }
}
