package com.getmati.mati_sdk.sentry.io.sentry.adapters;

import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.getmati.mati_sdk.sentry.io.sentry.SpanId;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Type;

public final class SpanIdDeserializerAdapter implements JsonDeserializer<SpanId> {

  private final @NotNull
  SentryOptions options;

  public SpanIdDeserializerAdapter(final @NotNull SentryOptions options) {
    this.options = options;
  }

  @Override
  public @Nullable
  SpanId deserialize(
      final @Nullable JsonElement json,
      final @Nullable Type typeOfT,
      final @NotNull JsonDeserializationContext context)
      throws JsonParseException {
    try {
      return json == null ? null : new SpanId(json.getAsString());
    } catch (Exception e) {
      options.getLogger().log(SentryLevel.ERROR, "Error when deserializing SpanId", e);
    }
    return null;
  }
}
