package com.getmati.mati_sdk.sentry.io.sentry.adapters;

import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;
import com.getmati.mati_sdk.sentry.io.sentry.SentryOptions;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Type;
import java.util.TimeZone;

public final class TimeZoneSerializerAdapter implements JsonSerializer<TimeZone> {

  private final @NotNull
  SentryOptions options;

  public TimeZoneSerializerAdapter(final @NotNull SentryOptions options) {
    this.options = options;
  }

  @Override
  public @Nullable JsonElement serialize(
      final @Nullable TimeZone src,
      final @NotNull Type typeOfSrc,
      final @NotNull JsonSerializationContext context) {
    try {
      return src == null ? null : new JsonPrimitive(src.getID());
    } catch (Exception e) {
      options.getLogger().log(SentryLevel.ERROR, "Error when serializing TimeZone", e);
    }
    return null;
  }
}
