package com.getmati.mati_sdk.sentry.io.sentry.android.core;

import android.os.Build;

import org.jetbrains.annotations.Nullable;

/** The Android Impl. of IBuildInfoProvider which returns the Build class info. */
public final class BuildInfoProvider implements IBuildInfoProvider {

  /**
   * Returns the Build.VERSION.SDK_INT
   *
   * @return the Build.VERSION.SDK_INT
   */
  @Override
  public int getSdkInfoVersion() {
    return Build.VERSION.SDK_INT;
  }

  @Override
  public @Nullable String getBuildTags() {
    return Build.TAGS;
  }
}
