package com.getmati.mati_sdk.sentry.io.sentry.android.core.util;

import android.os.Looper;

import org.jetbrains.annotations.NotNull;

import com.getmati.mati_sdk.sentry.io.sentry.protocol.SentryThread;

/** Class that checks if a given thread is the Android Main/UI thread */
public final class MainThreadChecker {

  private MainThreadChecker() {}

  /**
   * Checks if a given thread is the Android Main/UI thread
   *
   * @param thread the Thread
   * @return true if it is the main thread or false otherwise
   */
  public static boolean isMainThread(final @NotNull Thread thread) {
    return isMainThread(thread.getId());
  }

  /**
   * Checks if the calling/current thread is the Android Main/UI thread
   *
   * @return true if it is the main thread or false otherwise
   */
  public static boolean isMainThread() {
    return isMainThread(Thread.currentThread());
  }

  /**
   * Checks if a given thread is the Android Main/UI thread
   *
   * @param sentryThread the SentryThread
   * @return true if it is the main thread or false otherwise
   */
  public static boolean isMainThread(final @NotNull SentryThread sentryThread) {
    final Long threadId = sentryThread.getId();
    return threadId != null && isMainThread(threadId);
  }

  private static boolean isMainThread(final long threadId) {
    return Looper.getMainLooper().getThread().getId() == threadId;
  }
}
