package com.getmati.mati_sdk.sentry.io.sentry.android.core.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;

import org.jetbrains.annotations.NotNull;

import com.getmati.mati_sdk.sentry.io.sentry.util.Objects;

public final class Permissions {

  private Permissions() {}

  public static boolean hasPermission(
      final @NotNull Context context, final @NotNull String permission) {
    Objects.requireNonNull(context, "The application context is required.");

    return context.checkPermission(permission, Process.myPid(), Process.myUid())
        == PackageManager.PERMISSION_GRANTED;
  }
}
