package com.getmati.mati_sdk.sentry.io.sentry.android.ndk;

import org.jetbrains.annotations.Nullable;

import com.getmati.mati_sdk.sentry.io.sentry.protocol.SdkVersion;

/**
 * Util class to make SentryNdk testable, as SentryNdk inits native libraries and it breaks on init.
 */
final class SentryNdkUtil {

  private SentryNdkUtil() {}

  /**
   * Adds the sentry-android-ndk package into the package list
   *
   * @param sdkVersion the SdkVersion object
   */
  static void addPackage(@Nullable final SdkVersion sdkVersion) {
    if (sdkVersion == null) {
      return;
    }
    sdkVersion.addPackage("maven:io.sentry:sentry-android-ndk", "5.0.1");
  }
}
