package com.getmati.mati_sdk.sentry.io.sentry.transport;

import org.jetbrains.annotations.NotNull;

import java.net.Authenticator;

/** Wraps {@link Authenticator} in order to make classes that use it testable. */
final class AuthenticatorWrapper {
  private static final AuthenticatorWrapper instance = new AuthenticatorWrapper();

  public static AuthenticatorWrapper getInstance() {
    return instance;
  }

  private AuthenticatorWrapper() {}

  public void setDefault(final @NotNull Authenticator authenticator) {
    Authenticator.setDefault(authenticator);
  }
}
