package com.getmati.mati_sdk.sentry.io.sentry.transport;

import com.getmati.mati_sdk.sentry.io.sentry.SentryEnvelope;
import com.getmati.mati_sdk.sentry.io.sentry.cache.IEnvelopeCache;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Iterator;

public final class NoOpEnvelopeCache implements IEnvelopeCache {
  private static final NoOpEnvelopeCache instance = new NoOpEnvelopeCache();

  public static NoOpEnvelopeCache getInstance() {
    return instance;
  }

  @Override
  public void store(@NotNull SentryEnvelope envelope, @Nullable Object hint) {}

  @Override
  public void discard(@NotNull SentryEnvelope envelope) {}

  @NotNull
  @Override
  public Iterator<SentryEnvelope> iterator() {
    return new ArrayList<SentryEnvelope>(0).iterator();
  }
}
