package com.getmati.mati_sdk.sentry.io.sentry.transport;

import com.getmati.mati_sdk.sentry.io.sentry.SentryEnvelope;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;

public final class NoOpTransport implements ITransport {

  private static final NoOpTransport instance = new NoOpTransport();

  public static @NotNull
  NoOpTransport getInstance() {
    return instance;
  }

  private NoOpTransport() {}

  @Override
  public void send(final @NotNull SentryEnvelope envelope, final @Nullable Object hint)
      throws IOException {}

  @Override
  public void flush(long timeoutMillis) {}

  @Override
  public void close() throws IOException {}
}
