package com.getmati.mati_sdk.sentry.io.sentry.util;

import com.getmati.mati_sdk.sentry.io.sentry.hints.ApplyScopeData;
import com.getmati.mati_sdk.sentry.io.sentry.hints.Cached;

import org.jetbrains.annotations.Nullable;

/** Util class for Applying or not scope's data to an event */
public final class ApplyScopeUtils {

  private ApplyScopeUtils() {}

  /**
   * Scope's data should be applied if: Hint is of the type ApplyScopeData or Hint is not Cached
   * (this includes a null hint)
   *
   * @param hint the hint
   * @return true if it should apply scope's data or false otherwise
   */
  public static boolean shouldApplyScopeData(final @Nullable Object hint) {
    return (!(hint instanceof Cached) || (hint instanceof ApplyScopeData));
  }
}
