package com.getmati.mati_sdk.sentry.io.sentry.util;

import com.getmati.mati_sdk.sentry.io.sentry.ILogger;
import com.getmati.mati_sdk.sentry.io.sentry.SentryLevel;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogUtils {

  public static void logIfNotFlushable(final @NotNull ILogger logger, final @Nullable Object hint) {
    logger.log(
        SentryLevel.DEBUG,
        "%s is not Flushable",
        hint != null ? hint.getClass().getCanonicalName() : "Hint");
  }

  public static void logIfNotRetryable(final @NotNull ILogger logger, final @Nullable Object hint) {
    logger.log(
        SentryLevel.DEBUG,
        "%s is not Retryable",
        hint != null ? hint.getClass().getCanonicalName() : "Hint");
  }
}
